/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBData_Comum;
import fme.CBTabela;
import fme.CFType_Valor0;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_DadosAccoes;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;

class CBTabela_Invs2
extends CBTabela {
    Frame_DadosAccoes P;
    int tab_index = 0;

    @Override
    public String getPagina() {
        return CBData.getPagina(null, "Accoes", CBData.ListaAccoes, this.tab_index);
    }

    CBTabela_Invs2(Frame_DadosAccoes p, int idx) {
        this.P = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "Inv2";
        this.started = true;
        this.P.cbd_invs2 = this;
        this.cols = new CHTabColModel[6];
        this.cols[0] = new CHTabColModel("rubrica", "Rubrica (id)", true, true, false, null);
        this.cols[1] = new CHTabColModel("rubrica_d", "Rubrica", true, false, true, null);
        this.cols[2] = new CHTabColModel("valor_f1", "Custo do Investimento - Fase 1", true, CBData.Params.fases > 0, true, new CFType_Valor0());
        this.cols[3] = new CHTabColModel("valor_f2", "Custo do Investimento - Fase 2", true, CBData.Params.fases > 1, true, new CFType_Valor0());
        this.cols[4] = new CHTabColModel("valor_f3", "Custo do Investimento - Fase 3", true, CBData.Params.fases > 2, true, new CFType_Valor0());
        this.cols[5] = new CHTabColModel("valor_tt", "Custo do Investimento - Total", true, false, true, new CFType_Valor0());
        this.init_dados(4);
        this.init_handler(new CHTabQuadro(), this.P.getJTable_Invs2());
        this.P.getJTable_Invs2().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P.getJScrollPane_Invs2().getWidth() - 2;
        this.cols[0].disable_row_calc = true;
        this.cols[1].disable_row_calc = true;
        ((CHTabQuadro)this.handler).start_rows();
        ((CHTabQuadro)this.handler).row_editable[0] = false;
        ((CHTabQuadro)this.handler).row_editable[2] = false;
        this.keyCol = 0;
        ((String[])this.dados.elementAt((int)0))[0] = "S1";
        ((String[])this.dados.elementAt((int)1))[0] = "93";
        ((String[])this.dados.elementAt((int)2))[0] = "T1";
        ((String[])this.dados.elementAt((int)3))[0] = "71";
        ((String[])this.dados.elementAt((int)0))[1] = "Subtotal";
        ((String[])this.dados.elementAt((int)1))[1] = "Honor\u00e1rios";
        ((String[])this.dados.elementAt((int)2))[1] = "Custo Total da A\u00e7\u00e3o";
        ((String[])this.dados.elementAt((int)3))[1] = "do qual Vinho do Porto/Madeira/A\u00e7ores";
        ((String[])this.dados.elementAt((int)0))[2] = CBData.Params.fases > 0 ? "0" : "";
        ((String[])this.dados.elementAt((int)0))[3] = CBData.Params.fases > 1 ? "0" : "";
        ((String[])this.dados.elementAt((int)0))[4] = CBData.Params.fases > 2 ? "0" : "";
        ((String[])this.dados.elementAt((int)0))[5] = CBData.Params.fases > 0 ? "0" : "";
        ((String[])this.dados.elementAt((int)2))[2] = CBData.Params.fases > 0 ? "0" : "";
        ((String[])this.dados.elementAt((int)2))[3] = CBData.Params.fases > 1 ? "0" : "";
        ((String[])this.dados.elementAt((int)2))[4] = CBData.Params.fases > 2 ? "0" : "";
        ((String[])this.dados.elementAt((int)2))[5] = CBData.Params.fases > 0 ? "0" : "";
        this.handler.set_col_text(1, 0.504, "R");
        this.handler.set_col_text(2, 0.12, "R");
        this.handler.set_col_text(3, 0.12, "R");
        this.handler.set_col_text(4, 0.12, "R");
        this.handler.set_col_text(5, 0.12, "R");
        ((CHTabQuadro)this.handler).row_autocalc[2] = "$soma(+0,+1)";
    }

    @Override
    void on_update(String colname, int nRow, String v) {
        String f1 = this.getColValue("valor_f1", nRow);
        String f2 = this.getColValue("valor_f2", nRow);
        String f3 = this.getColValue("valor_f3", nRow);
        if ((String.valueOf(f1) + f2 + f3).equals("")) {
            this.setColValue("valor_tt", nRow, "");
        } else {
            double total = _lib.to_double(f1) + _lib.to_double(f2) + _lib.to_double(f3);
            this.setColValue("valor_tt", nRow, total == 0.0 ? "0" : String.valueOf(_lib.round(total)));
        }
        this.autocalc2(true, true, 2);
        this.handler.j.revalidate();
        this.handler.j.repaint();
        if (colname.startsWith("valor_")) {
            double sum = _lib.round(_lib.to_double(this.getColValue(colname, this.dados.size() - 2)));
            if (sum != 0.0) {
                CBData.ListaAccoes.setColValue(colname, this.tab_index - 1, String.valueOf(sum));
                CBData.ListaAccoes.on_update(colname, this.tab_index - 1, String.valueOf(sum));
            } else {
                CBData.ListaAccoes.setColValue(colname, this.tab_index - 1, "");
                CBData.ListaAccoes.on_update(colname, this.tab_index - 1, "");
            }
            CBData.ListaAccoes.handler.j.revalidate();
            CBData.ListaAccoes.handler.j.repaint();
            CBData.ListaAccoes.calc_desp_fin(colname);
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        String titulo = "";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        StringBuffer mask = new StringBuffer("--???-");
        mask.setCharAt(2, CBData.Params.fases > 0 ? (char)'R' : '-');
        mask.setCharAt(3, CBData.Params.fases > 1 ? (char)'R' : '-');
        mask.setCharAt(4, CBData.Params.fases > 2 ? (char)'R' : '-');
        boolean entidade_terceira = false;
        if (CBData.Execucao.getByName((String)"entidade_terceira").v.equals("1")) {
            entidade_terceira = true;
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg((CBData_Comum)this, "Lista vazia"));
        } else {
            int j = 0;
            while (j < this.dados.size()) {
                TabError[] e = this.isIncompletAll(j, mask.toString());
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg((CBData_Comum)this, e[ii], e[ii].msg("Linha '" + this.getColValue("rubrica_d", j) + "' incompleta: %T - %o")));
                    ++ii;
                }
                if (j == 1 && !entidade_terceira) {
                    boolean temDados = false;
                    int nCol = 2;
                    while (nCol < ((String[])this.dados.elementAt(j)).length - 1) {
                        String x = ((String[])this.dados.elementAt(j))[nCol];
                        if (x != null && !x.equals("") && !x.equals("0")) {
                            temDados = true;
                            break;
                        }
                        ++nCol;
                    }
                    if (temDados) {
                        err_list.add_msg(new CHValid_Msg((CBData_Comum)this, "S\u00f3 pode apresentar honor\u00e1rios, se existirem entidades executoras contratadas"));
                    }
                }
                ++j;
            }
            double total = _lib.round(_lib.to_double(this.getColValue("valor_tt", 2)));
            if (total <= 0.0) {
                String accao = CBData.ListaAccoes.getColValue("tipo_d", this.tab_index - 1);
                err_list.add_msg(new CHValid_Msg((CBData_Comum)this, "O custo total da a\u00e7\u00e3o " + accao + " tem que ser superior a 0."));
            }
        }
        return err_list;
    }
}

